/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.packets;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.network.packets.PacketHelper;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSAddModules
implements IMessage {
    private int x;
    private int y;
    private int z;
    private ItemStack[] modules;
    private int arrayLength;

    public PacketSAddModules() {
    }

    public PacketSAddModules(int x, int y, int z, ItemStack ... modules) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.modules = modules;
        this.arrayLength = modules.length;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.arrayLength);
        for (ItemStack stack : this.modules) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.arrayLength = buf.readInt();
        for (int i = 0; i < this.arrayLength; ++i) {
            if (this.modules == null) {
                this.modules = new ItemStack[this.arrayLength];
            }
            this.modules[i] = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
    }

    public static class Handler
    extends PacketHelper
    implements IMessageHandler<PacketSAddModules, IMessage> {
        public IMessage onMessage(PacketSAddModules message, MessageContext context) {
            WorldUtils.addScheduledTask(this.getWorld((EntityPlayer)context.getServerHandler().field_147369_b), () -> {
                BlockPos pos = BlockUtils.toPos(message.x, message.y, message.z);
                ItemStack[] modules = message.modules;
                EntityPlayerMP player = context.getServerHandler().field_147369_b;
                if (this.getWorld((EntityPlayer)player).func_175625_s(pos) != null && this.getWorld((EntityPlayer)player).func_175625_s(pos) instanceof CustomizableSCTE) {
                    for (ItemStack module : modules) {
                        if (((CustomizableSCTE)this.getWorld((EntityPlayer)player).func_175625_s(pos)).hasModule(EnumCustomModules.getModuleFromStack(module))) continue;
                        ((CustomizableSCTE)this.getWorld((EntityPlayer)player).func_175625_s(pos)).insertModule(module);
                    }
                }
            });
            return null;
        }
    }
}

